package ru.yandex.webmaster3.storage.metrika.data;


import lombok.AllArgsConstructor;
import lombok.Getter;
import lombok.ToString;
import org.joda.time.DateTime;
import org.joda.time.LocalDate;

@Getter
@ToString
@AllArgsConstructor
public class MetrikaStatsByTime {
    private final LocalDate tableDate;
    private final LocalDate date;
    private final Long visits;
    private final Long bounceCount;
    private final Double bounceRate;

    public MetrikaStatsByTime(LocalDate tableDate, LocalDate date, Long visits, Long bounceCount) {
        this.tableDate = tableDate;
        this.date = date;
        this.visits = visits;
        this.bounceCount = bounceCount;

        if (visits != null && bounceCount != null) {
            bounceRate = (double) bounceCount / (double) visits;
        } else {
            bounceRate = null;
        }
    }
}
