package ru.yandex.webmaster3.storage.mirrors.dao;

import java.util.Map;

import org.apache.commons.lang3.tuple.Pair;
import org.joda.time.DateTime;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;

import ru.yandex.webmaster3.core.data.WebmasterHostId;
import ru.yandex.webmaster3.core.util.W3Collectors;
import ru.yandex.webmaster3.storage.host.CommonDataType;
import ru.yandex.webmaster3.storage.settings.SettingsService;
import ru.yandex.webmaster3.storage.util.ydb.AbstractYDao;
import ru.yandex.webmaster3.storage.util.ydb.querybuilder.typesafe.DataMapper;
import ru.yandex.webmaster3.storage.util.ydb.querybuilder.typesafe.Field;
import ru.yandex.webmaster3.storage.util.ydb.querybuilder.typesafe.Fields;


/**
 * @author kravchenko99
 * @date 5/13/21
 */

@Repository
public class NewMainMirrorCacheYDao extends AbstractYDao {
    private static final String TABLE_NAME = "new_main_mirror_cache";

    @Autowired
    private SettingsService settingsService;

    public NewMainMirrorCacheYDao() {
        super(PREFIX_WEBMASTER3, TABLE_NAME);
    }

    public void add(WebmasterHostId hostId, WebmasterHostId mirrorId) {
        upsert(F.HOST_ID.value(hostId), F.MIRROR_ID.value(mirrorId), F.UPDATE_TIME.value(DateTime.now())).execute();
    }


    public Map<WebmasterHostId, WebmasterHostId> getAll() {
        return select(MAPPER).queryForList(Pair.of(F.HOST_ID, Pair::getKey))
                .stream().collect(W3Collectors.toHashMap());
    }

    public void clear() {
        DateTime dateTime =
                new DateTime(Long.parseLong(settingsService.getSettingUncached(CommonDataType.LAST_EXPORTED_HOSTS).getValue()));
        delete().where(F.UPDATE_TIME.lt(dateTime)).execute();
    }

    private static final DataMapper<Pair<WebmasterHostId, WebmasterHostId>> MAPPER = DataMapper.create(
            F.HOST_ID, F.MIRROR_ID, Pair::of
    );

    private interface F {
        Field<WebmasterHostId> HOST_ID = Fields.hostIdField("host_id");
        Field<WebmasterHostId> MIRROR_ID = Fields.hostIdField("mirror_id");
        Field<DateTime> UPDATE_TIME = Fields.jodaDateTimeField("update_time");
    }
}
