package ru.yandex.webmaster3.storage.mirrors.data;

import java.util.UUID;

import lombok.Getter;
import org.joda.time.DateTime;

import ru.yandex.webmaster3.core.data.WebmasterHostId;

/**
 * User: azakharov
 * Date: 07.07.15
 * Time: 13:09
 */
@Getter
public class MirrorRequest {
    private final UUID requestId;
    // host which main mirror is being changed
    private final WebmasterHostId hostId;
    // request state (new, done, error)
    private final MirrorRequestStateEnum state;
    // desired new main mirror host id
    private final WebmasterHostId newMainMirrorHostId;
    // current main mirror host id at the create time
    private final WebmasterHostId oldMainMirrorHostId;

    // create date of request
    private final DateTime createDate;
    // update date of request (change state, set sita response, decrement attemptsCount)
    private final DateTime updateDate;

    private final int attemptCount;
    private final String serviceResponse;

    private final MirrorActionEnum action;
    private final boolean hidden;

    public MirrorRequest(WebmasterHostId hostId, UUID requestId, MirrorRequestStateEnum state,
                         WebmasterHostId oldMainMirrorHostId, WebmasterHostId newMainMirrorHostId,
                         DateTime createDate, DateTime updateDate, int attemptCount, String serviceResponse,
                         MirrorActionEnum action, boolean hidden) {
        this.requestId = requestId;
        this.hostId = hostId;
        this.state = state;
        this.newMainMirrorHostId = newMainMirrorHostId;
        this.oldMainMirrorHostId = oldMainMirrorHostId == null ? hostId : oldMainMirrorHostId;
        this.createDate = createDate;
        this.updateDate = updateDate;
        this.attemptCount = attemptCount;
        this.serviceResponse = serviceResponse;
        this.action = action;
        this.hidden = hidden;
    }

    public MirrorRequest(WebmasterHostId hostId, MirrorRequestStateEnum state,
                         WebmasterHostId oldMainMirrorHostId, WebmasterHostId newMainMirrorHostId,
                         DateTime createDate, DateTime updateDate, int attemptCount, String serviceResponse,
                         MirrorActionEnum action, boolean hidden) {
        this.requestId = null;
        this.hostId = hostId;
        this.state = state;
        this.newMainMirrorHostId = newMainMirrorHostId;
        this.oldMainMirrorHostId = oldMainMirrorHostId == null ? hostId : oldMainMirrorHostId;
        this.createDate = createDate;
        this.updateDate = updateDate;
        this.attemptCount = attemptCount;
        this.serviceResponse = serviceResponse;
        this.action = action;
        this.hidden = hidden;
    }

    public MirrorRequest withState(MirrorRequestStateEnum state) {
        return new MirrorRequest(hostId, requestId, state, oldMainMirrorHostId, newMainMirrorHostId, createDate, DateTime.now(), attemptCount, serviceResponse, action, hidden);
    }

    public MirrorRequest withAttempts(int attemptCount) {
        return new MirrorRequest(hostId, requestId, state, oldMainMirrorHostId, newMainMirrorHostId, createDate, DateTime.now(), attemptCount, serviceResponse, action, hidden);
    }

    public MirrorRequest withServiceResponse(String serviceResponse) {
        return new MirrorRequest(hostId, requestId, state, oldMainMirrorHostId, newMainMirrorHostId, createDate, DateTime.now(), attemptCount, serviceResponse, action, hidden);
    }

    public MirrorRequest hidden() {
        return new MirrorRequest(hostId, requestId, state, oldMainMirrorHostId, newMainMirrorHostId, createDate, updateDate, attemptCount, serviceResponse, action, true);
    }

    public MirrorRequest withUpdateDate(DateTime updateDate) {
        return new MirrorRequest(hostId, requestId, state, oldMainMirrorHostId, newMainMirrorHostId, createDate, updateDate, attemptCount, serviceResponse, action, hidden);
    }
}
