package ru.yandex.webmaster3.storage.mirrors.data;

import ru.yandex.webmaster3.core.util.enums.IntEnum;
import ru.yandex.webmaster3.core.util.enums.IntEnumResolver;

/**
 *
@startuml
[*] --> NEW : User change mirror
NEW : Call NEW_MIRRORING service

NEW --> WAITING
WAITING : NEW_MIRRORING return OK
WAITING : Wait up to 60 days

WAITING --> WAITING : Check current host mirror
WAITING --> SUCCESS
SUCCESS : Host mirror updated within 60 days
SUCCESS : Host mirror equals desired

WAITING --> EXPIRED
EXPIRED : Host mirror not equals desired within 60 days

NEW --> SERVICE_ERROR
SERVICE_ERROR : NEW_MIRRORING return ERROR_TIMEOUT
SERVICE_ERROR : NEW_MIRRORING return ERROR_SERVICE

NEW --> USER_ERROR
USER_ERROR : NEW_MIRRORING return ERROR_USER

NEW --> NEW : NEW_MIRRORING failed and attempts <= 3
NEW --> INTERNAL_ERROR
INTERNAL_ERROR : NEW_MIRRORING failed and attempts > 3

SUCCESS --> [*]
INTERNAL_ERROR --> [*]
SERVICE_ERROR --> [*]
EXPIRED --> [*]
USER_ERROR --> [*]
 @enduml
 *
 * User: azakharov
 * Date: 07.07.15
 * Time: 13:05
 */
public enum MirrorRequestStateEnum implements IntEnum {
    NEW(0, false),
    WAITING(1, false),
    SERVICE_ERROR(2, true),
    INTERNAL_ERROR(3, true),
    SUCCESS(4, true),
    EXPIRED(5, true),
    USER_ERROR(6, true),
    ;

    private final int code;
    private final boolean terminal;

    MirrorRequestStateEnum(int code, boolean terminal) {
        this.code = code;
        this.terminal = terminal;
    }

    public boolean isTerminal() {
        return terminal;
    }

    @Override
    public int value() {
        return code;
    }

    public static final IntEnumResolver<MirrorRequestStateEnum> R = IntEnumResolver.r(MirrorRequestStateEnum.class);
}
