package ru.yandex.webmaster3.storage.mobile.dao;

import org.joda.time.DateTime;
import org.springframework.stereotype.Repository;

import ru.yandex.webmaster3.core.data.WebmasterHostId;
import ru.yandex.webmaster3.storage.util.ydb.AbstractYDao;
import ru.yandex.webmaster3.storage.util.ydb.querybuilder.typesafe.DataMapper;
import ru.yandex.webmaster3.storage.util.ydb.querybuilder.typesafe.Field;
import ru.yandex.webmaster3.storage.util.ydb.querybuilder.typesafe.Fields;

/**
 * @author leonidrom
 *
 * WMC-10102: хосты, которые всегда признаются мобилопригодными
 */
@Repository
public class HostMobileAuditResultsOverrideYDao extends AbstractYDao  {
    private static final String TABLE_NAME = "host_mobile_audit_results_override";

    public HostMobileAuditResultsOverrideYDao() {
        super(PREFIX_MOBILE, TABLE_NAME);
    }

    public boolean isExists(WebmasterHostId hostId) {
        return select(MAPPER)
                .where(F.HOST_ID.eq(hostId))
                .queryOne() != null;
    }

    public void clearOldRecords(DateTime ts) {
        delete().where(F.TABLE_TS.lt(ts)).execute();
    }

    public String getTablePath() {
        return tablePrefix + "/" + tableName;
    }

    public static class F {
        static final Field<WebmasterHostId> HOST_ID = Fields.hostIdField("host_id");
        static final Field<DateTime> TABLE_TS = Fields.jodaDateTimeField("table_ts");
    }

    public static final DataMapper<WebmasterHostId> MAPPER = DataMapper.create(F.HOST_ID, h -> h);
}
