package ru.yandex.webmaster3.storage.mobile.data;

import com.datastax.driver.core.utils.UUIDs;
import lombok.ToString;
import org.joda.time.DateTime;
import ru.yandex.webmaster3.core.data.WebmasterHostId;
import ru.yandex.webmaster3.core.mobile.data.ScreenshotResolution;

import java.net.URL;
import java.util.UUID;

/**
 * @author avhaliullin
 */
@ToString
public class MobileAuditRequestInfo {
    private final long userId;
    private final WebmasterHostId hostId;
    private final URL url;
    private final ScreenshotResolution resolution;
    private final UUID requestId;
    private final DateTime lastUpdate;
    private final MobileAuditRequestState state;
    private final MobileAuditResult result;
    private final boolean adminRequest;

    public MobileAuditRequestInfo(long userId, WebmasterHostId hostId, URL url, ScreenshotResolution resolution, UUID requestId,
                                  DateTime lastUpdate, MobileAuditRequestState state, MobileAuditResult result, boolean adminRequest) {
        this.userId = userId;
        this.hostId = hostId;
        this.url = url;
        this.resolution = resolution;
        this.requestId = requestId;
        this.lastUpdate = lastUpdate;
        this.result = result;
        this.state = state;
        this.adminRequest = adminRequest;
    }

    public ScreenshotResolution getResolution() {
        return resolution;
    }

    public long getUserId() {
        return userId;
    }

    public WebmasterHostId getHostId() {
        return hostId;
    }

    public URL getUrl() {
        return url;
    }

    public UUID getRequestId() {
        return requestId;
    }

    public DateTime getLastUpdate() {
        return lastUpdate;
    }

    public MobileAuditResult getResult() {
        return result;
    }

    public MobileAuditRequestState getState() {
        return state;
    }

    public DateTime getCreatedAt() {
        return new DateTime(UUIDs.unixTimestamp(requestId));
    }

    public boolean isAdminRequest() {
        return adminRequest;
    }

    public MobileAuditRequestInfo withResult(MobileAuditResult result) {
        return new MobileAuditRequestInfo(userId, hostId, url, resolution, requestId, lastUpdate, MobileAuditRequestState.TASK_FINISHED, result, adminRequest);
    }
}
