package ru.yandex.webmaster3.storage.mobile.data;

import ru.yandex.webmaster3.core.util.enums.IntEnum;
import ru.yandex.webmaster3.core.util.enums.IntEnumResolver;

/**
 * @author avhaliullin
 */
public enum MobileAuditRequestState implements IntEnum {
    NEW(0),
    TASK_STARTED(1),
    TASK_FINISHED(2)
    ;

    private final int value;

    MobileAuditRequestState(int value) {
        this.value = value;
    }

    @Override
    public int value() {
        return value;
    }

    public static final IntEnumResolver<MobileAuditRequestState> R = IntEnumResolver.r(MobileAuditRequestState.class);
}
