package ru.yandex.webmaster3.storage.monitoring.common.dao;

/*
 * @author kravchenko99
 * @date 8/21/20
 */

import org.joda.time.DateTime;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;

import ru.yandex.webmaster3.storage.monitoring.common.MonitoringDataState;
import ru.yandex.webmaster3.storage.monitoring.common.MonitoringDataType;
import ru.yandex.webmaster3.storage.settings.dao.AbstractCommonDataStateYDao;

@Repository
public class MonitoringDataStateYDao extends AbstractCommonDataStateYDao<MonitoringDataType, MonitoringDataState> {
    private static final String TABLE_NAME = "monitoring_data_state";

    @Autowired
    public MonitoringDataStateYDao() {
        super(PREFIX_MONITORING, TABLE_NAME, MonitoringDataType.R);
    }

    protected MonitoringDataState createData(MonitoringDataType type, String value, DateTime updateDate) {
        return new MonitoringDataState(type, value, updateDate);
    }


    @Override
    public void update(MonitoringDataState commonDataState) {
        super.update(commonDataState);
    }
}
