package ru.yandex.webmaster3.storage.nca;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

import com.fasterxml.jackson.core.type.TypeReference;
import org.apache.commons.lang3.tuple.Pair;
import org.joda.time.DateTime;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;

import ru.yandex.webmaster3.core.feeds.feed.FeedsDefectRateErrorExample;
import ru.yandex.webmaster3.storage.settings.SettingsService;
import ru.yandex.webmaster3.storage.util.ydb.AbstractYDao;
import ru.yandex.webmaster3.storage.util.ydb.querybuilder.typesafe.DataMapper;
import ru.yandex.webmaster3.storage.util.ydb.querybuilder.typesafe.Field;
import ru.yandex.webmaster3.storage.util.ydb.querybuilder.typesafe.Fields;


/**
 * @author kravchenko99
 * @date 3/22/22
 */

@Repository
public class NcaRulesYDao extends AbstractYDao {
    private static final String TABLE_NAME = "nca_rules";

    @Autowired
    private SettingsService settingsService;

    public NcaRulesYDao() {
        super(PREFIX_NCA, TABLE_NAME);
    }

    public void deleteBefore(DateTime dt) {
        delete().where(F.TIME_INSERT.lt(dt)).execute();
    }

    public Map<String, DateTime> getAll() {
        Map<String, DateTime> result = new HashMap<>();
        streamReader(MAPPER, x -> result.put(x.getKey(), x.getValue()));
        return result;
    }

    public static final DataMapper<Pair<String, DateTime>> MAPPER = DataMapper.create(F.RULE, F.ADD_TIMESTAMP,
            Pair::of);

    private interface F {
        TypeReference<List<FeedsDefectRateErrorExample>> LIST = new TypeReference<>() {
        };
        //key
        Field<String> RULE = Fields.stringField("rule");

        Field<DateTime> ADD_TIMESTAMP = Fields.jodaDateTimeField("add_timestamp");
        Field<DateTime> TIME_INSERT = Fields.jodaDateTimeField("time_insert");
    }
}
