package ru.yandex.webmaster3.storage.nca.data;

import lombok.AllArgsConstructor;

import ru.yandex.webmaster3.core.util.enums.IntEnum;
import ru.yandex.webmaster3.core.util.enums.IntEnumResolver;

/**
 * @author kravchenko99
 * @date 4/27/22
 */

@AllArgsConstructor
public enum LogEntryType implements IntEnum {
    X509_ENTRY(0),
    PRECERT_ENTRY(1),
    UNKNOWN_ENTRY_TYPE(65535);
    public final int n;

    @Override
    public int value() {
        return n;
    }

    public static final IntEnumResolver<LogEntryType> R = IntEnumResolver.r(LogEntryType.class);
}
