package ru.yandex.webmaster3.storage.nca.data;

import java.util.Date;
import java.util.List;

import lombok.AccessLevel;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Value;

/**
 * @author kravchenko99
 * @date 4/27/22
 */

@Value
@AllArgsConstructor(access = AccessLevel.PUBLIC)
@Builder(toBuilder = true)
public class ParsedCertificateState {
    List<String> domains;
    String subject;
    String issuer;
    Date notBefore;
    Date notAfter;
    LogEntryType logEntryType;
    String serialNumber;
    String signature;
    String certificateAlgorithm;
    String certificatePEM;
    String subjectAlgorithm;
    String subjectPEM;
}
