package ru.yandex.webmaster3.storage.news;

import java.util.Map;
import java.util.stream.Collectors;

import com.google.common.base.Strings;
import org.apache.commons.lang3.tuple.Pair;
import org.springframework.stereotype.Repository;

import ru.yandex.webmaster3.storage.util.ydb.AbstractYDao;
import ru.yandex.webmaster3.storage.util.ydb.querybuilder.QueryBuilder;
import ru.yandex.webmaster3.storage.util.ydb.querybuilder.Select;
import ru.yandex.webmaster3.storage.util.ydb.querybuilder.typesafe.DataMapper;
import ru.yandex.webmaster3.storage.util.ydb.querybuilder.typesafe.Field;
import ru.yandex.webmaster3.storage.util.ydb.querybuilder.typesafe.Fields;

/**
 * ishalaru
 * 17.11.2020
 **/
@Repository
public class MassMediaDictYDao extends AbstractYDao {
    public MassMediaDictYDao() {
        super(PREFIX_WEBMASTER3, "mass_media_dict");
    }

    public void upsert(Long id, String name) {
        execute(upsert(F.ID.value(id), F.NAME.value(name)));
    }

    public Map<Long, String> load(String template, int limit) {
        final Select<Pair<Long, String>> select = select(MAPPER);
        if (!Strings.isNullOrEmpty(template)) {
            select.where(QueryBuilder.toLower(F.NAME).like(template.toLowerCase()));
        }

        return select.limit(limit).queryForList()
                .stream().collect(Collectors.toMap(Pair::getLeft, Pair::getRight));
    }

    private static final DataMapper<Pair<Long, String>> MAPPER =
            DataMapper.create(F.ID, F.NAME, (id, name) -> Pair.of(id, name));


    private interface F {
        Field<Long> ID = Fields.longField("id");
        Field<String> NAME = Fields.stringField("name");
    }
}
