package ru.yandex.webmaster3.storage.news;

import java.util.List;
import java.util.Map;
import java.util.Set;

import lombok.RequiredArgsConstructor;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import ru.yandex.webmaster3.core.data.WebmasterHostId;

/**
 * ishalaru
 * 17.11.2020
 **/
@Service
@RequiredArgsConstructor(onConstructor_ = {@Autowired})
public class MassMediaService {
    private final MassMediaDictYDao massMediaDictYDao;
    private final TrustedMassMediaYDao trustedMassMediaYDao;

    public Map<Long, String> loadDict(String template, int limit) {
        return massMediaDictYDao.load(template, limit);
    }

    public void saveTrustedMassMedia(WebmasterHostId hostId, List<Media> trustedMM) {
        trustedMassMediaYDao.insert(hostId, trustedMM);
    }

    public Set<Long> loadTrustedMassMedia(WebmasterHostId hostId) {
        return trustedMassMediaYDao.select(hostId);
    }

}
