package ru.yandex.webmaster3.storage.news;

import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;

import com.fasterxml.jackson.core.type.TypeReference;
import org.apache.commons.lang3.tuple.Pair;
import org.joda.time.DateTime;
import org.springframework.stereotype.Repository;

import ru.yandex.webmaster3.core.data.WebmasterHostId;
import ru.yandex.webmaster3.storage.util.ydb.AbstractYDao;
import ru.yandex.webmaster3.storage.util.ydb.querybuilder.typesafe.DataMapper;
import ru.yandex.webmaster3.storage.util.ydb.querybuilder.typesafe.Field;
import ru.yandex.webmaster3.storage.util.ydb.querybuilder.typesafe.Fields;

/**
 * ishalaru
 * 17.11.2020
 **/
@Repository
public class TrustedMassMediaYDao extends AbstractYDao {
    public static final TypeReference<Set<Long>> TYPE_REFERENCE = new TypeReference<>() {
    };

    public TrustedMassMediaYDao() {
        super(PREFIX_WEBMASTER3, "trusted_mass_media");
    }


    public void insert(WebmasterHostId hostId, List<Media> trustedMassMedias) {
        final Set<Long> select = select(hostId);
        for (Media media : trustedMassMedias) {
            if (media.isSelected()) {
                select.add(media.getId());
            } else {
                select.remove(media.getId());
            }
        }
        execute(upsert(F.HOST_ID.value(hostId),
                F.MM_LIST.value(select),
                F.UPDATED.value(DateTime.now())));
    }

    public Set<Long> select(WebmasterHostId hostId) {
        return Optional.ofNullable(queryOne(select(MAPPER).where(F.HOST_ID.eq(hostId)).getStatement(), MAPPER)).orElse(new HashSet<>(0));
    }

    public void forEach(Consumer<Pair<WebmasterHostId, Set<Long>>> consumer) {
        streamReader(DATA_MAPPER, consumer);
    }

    private static final DataMapper<Pair<WebmasterHostId, Set<Long>>> DATA_MAPPER =
            DataMapper.create(F.HOST_ID, F.MM_LIST, Pair::of);
    private static final DataMapper<Set<Long>> MAPPER = DataMapper.create(F.MM_LIST, a -> a);

    private interface F {
        Field<WebmasterHostId> HOST_ID = Fields.hostIdField("host_id");
        Field<Set<Long>> MM_LIST = Fields.jsonField("trusted_mm", TYPE_REFERENCE);
        Field<DateTime> UPDATED = Fields.jodaDateTimeField("updated");
    }
}
