package ru.yandex.webmaster3.storage.niche;

import java.util.List;

import ru.yandex.webmaster3.core.util.enums.IntEnum;
import ru.yandex.webmaster3.core.util.enums.IntEnumResolver;
import ru.yandex.webmaster3.storage.util.clickhouse2.query.QueryBuilder;
import ru.yandex.webmaster3.storage.util.clickhouse2.query.Statement;

/**
 * ishalaru
 * 08.07.2021
 **/
public enum QuerySource implements IntEnum {
    ALL(3),
    MINED(2),
    USER(1);

    private final int value;

    QuerySource(int value) {
        this.value = value;
    }

    public int getValue() {
        return value;
    }

    @Override
    public int value() {
        return value;
    }

    public static final IntEnumResolver<QuerySource> R = IntEnumResolver.r(QuerySource.class);

    public Statement getQueryFilter(String fieldName) {
        if (value == 3){
            return QueryBuilder.in(fieldName, List.of(1,2,3));
        }
        return QueryBuilder.eq(fieldName, value);
    }
}
