package ru.yandex.webmaster3.storage.niche.download;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Value;
import org.joda.time.DateTime;

import ru.yandex.webmaster3.core.data.WebmasterHostId;
import ru.yandex.webmaster3.storage.download.common.DownloadFileType;
import ru.yandex.webmaster3.storage.download.common.MdsExportDescriptor;
import ru.yandex.webmaster3.storage.niche.QuerySource;
import ru.yandex.webmaster3.storage.searchquery.DeviceType;

/**
 * Created by Oleg Bazdyrev on 27/07/2021.
 */
@Value
public class NicheQueriesMdsExportDescriptor extends MdsExportDescriptor {
    WebmasterHostId hostId;
    DateTime dateFrom;
    DateTime dateTo;
    DeviceType deviceType;
    Integer[] regionsId;
    QuerySource source;

    @JsonCreator
    public NicheQueriesMdsExportDescriptor(@JsonProperty("hostId") WebmasterHostId hostId,
                                           @JsonProperty("dateFrom") DateTime dateFrom,
                                           @JsonProperty("dateTo") DateTime dateTo,
                                           @JsonProperty("deviceType") DeviceType deviceType,
                                           @JsonProperty("regionsId") Integer[] regionsId,
                                           @JsonProperty("source") QuerySource source) {
        super(DownloadFileType.NICHE_QUERIES);
        this.hostId = hostId;
        this.dateFrom = dateFrom;
        this.dateTo = dateTo;
        this.deviceType = deviceType;
        this.regionsId = regionsId;
        this.source = source;
    }
}
