package ru.yandex.webmaster3.storage.niche2.filters;

import com.fasterxml.jackson.annotation.JsonCreator;
import org.apache.commons.lang3.StringUtils;

import ru.yandex.webmaster3.storage.AbstractFilter;
import ru.yandex.webmaster3.storage.niche2.Niche2QueriesCHDao;
import ru.yandex.webmaster3.storage.util.clickhouse2.condition.BoolOpCondition;


public class FilterEntity extends AbstractFilter<Niche2QueriesCHDao.FilterEnum> {
    @JsonCreator
    public FilterEntity(Niche2QueriesCHDao.FilterEnum indicator, Operation operation, String value,
                        BoolOpCondition.Operator logicalOperator) {
        super(indicator, operation, value, logicalOperator);
    }

    public static FilterEntity buildTrimmed(FilterEntity filterEntity) {
        String filter = filterEntity.getValue();
        if (filter != null) {
            filter = filter.trim().toLowerCase();
            if (StringUtils.isEmpty(filter)) {
                filter = null;
            }
        }
        return new FilterEntity(
                filterEntity.getIndicator(),
                filterEntity.getOperation(),
                filter,
                filterEntity.getLogicalOperator()
        );
    }
}
