package ru.yandex.webmaster3.storage.notifications;

import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;

import lombok.Getter;
import org.jetbrains.annotations.Nullable;
import org.joda.time.DateTime;
import org.springframework.web.util.UriComponentsBuilder;

import ru.yandex.webmaster3.core.data.WebmasterHostId;
import ru.yandex.webmaster3.core.util.TimeUtils;

/*
 * @author leonidrom
 */

@Getter
public class EmailTrackingInfo {
    @Nullable
    // Некоторые сообщения не привязаны к hostId
    private final String hostId;

    private final long userId;
    private final String messageType;
    private final long timestamp;

    public EmailTrackingInfo(@Nullable WebmasterHostId hostId, long userId, String messageType, DateTime dateTime) {
        this(hostId == null ? null : hostId.toStringId(), userId, messageType, TimeUtils.toUnixTimestamp(dateTime));
    }

    public EmailTrackingInfo(long userId, String messageType, DateTime dateTime) {
        this(null, userId, messageType, TimeUtils.toUnixTimestamp(dateTime));
    }

    private EmailTrackingInfo(@Nullable String hostId, long userId, String messageType, long timestamp) {
        this.hostId = hostId;
        this.userId = userId;
        this.messageType = messageType;
        this.timestamp = timestamp;
    }

    public List<byte[]> getDataAsBytes() {
        List<byte[]> result = new ArrayList<>();
        if (hostId != null) {
            result.add(getBytes(hostId));
        }
        result.add(getBytes(userId));
        result.add(getBytes(messageType));
        result.add(getBytes(timestamp));

        return result;
    }

    public void addToQueryParams(UriComponentsBuilder builder) {
        if (hostId != null) {
            builder.queryParam("hostId", hostId);
        }

        builder.queryParam("userId", userId);
        builder.queryParam("messageType", messageType);
        builder.queryParam("timestamp", timestamp);
    }

    protected byte[] getBytes(Object o) {
        return String.valueOf(o).getBytes(StandardCharsets.UTF_8);
    }
}
