package ru.yandex.webmaster3.storage.notifications;

import java.util.EnumSet;
import java.util.Set;

import ru.yandex.webmaster3.core.util.enums.IntEnum;
import ru.yandex.webmaster3.core.util.enums.IntEnumResolver;

/**
 * @author avhaliullin
 */
public enum NotificationChannel implements IntEnum {
    SERVICE(0),
    EMAIL(1),
    SUP(2),
    BELL(3),
    ;

    private final int value;

    NotificationChannel(int value) {
        this.value = value;
    }

    @Override
    public int value() {
        return value;
    }

    public static final IntEnumResolver<NotificationChannel> R = IntEnumResolver.r(NotificationChannel.class);
    public static final Set<NotificationChannel> ALL_NOTIFICATION_CHANNEL = EnumSet.allOf(NotificationChannel.class);

}
