package ru.yandex.webmaster3.storage.notifications;

import java.util.UUID;

/**
 * @author avhaliullin
 */
public class NotificationRecListId {
    private final UUID notificationId;
    private final UUID listId;

    public NotificationRecListId(UUID notificationId, UUID listId) {
        this.notificationId = notificationId;
        this.listId = listId;
    }

    public UUID getNotificationId() {
        return notificationId;
    }

    public UUID getListId() {
        return listId;
    }

    @Override
    public String toString() {
        return "(notificationId=" + notificationId + ", listId=" + listId + ")";
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;

        NotificationRecListId that = (NotificationRecListId) o;

        if (!notificationId.equals(that.notificationId)) return false;
        return listId.equals(that.listId);

    }

    @Override
    public int hashCode() {
        int result = notificationId.hashCode();
        result = 31 * result + listId.hashCode();
        return result;
    }
}
