package ru.yandex.webmaster3.storage.notifications;

import com.google.protobuf.InvalidProtocolBufferException;
import ru.yandex.webmaster3.core.WebmasterException;
import ru.yandex.webmaster3.core.http.WebmasterErrorResponse;
import ru.yandex.webmaster3.proto.notifications.Notifications;

import java.util.UUID;

/**
 * @author avhaliullin
 */
public class NotificationZKHelper {
    public static byte[] dumpNotificationProgress(NotificationProgress progress) {
        return progress.convertToProto().toByteArray();
    }

    public static NotificationProgress getNotificationProgress(byte[] bytes) {
        try {
            return NotificationProgress.convertFromProto(Notifications.NotificationProgress.parseFrom(bytes));
        } catch (InvalidProtocolBufferException e) {
            throw new WebmasterException("Failed to convert NotificationProgress message from proto",
                    new WebmasterErrorResponse.InternalUnknownErrorResponse(NotificationZKHelper.class, null), e);
        }
    }
}
