package ru.yandex.webmaster3.storage.notifications;

import com.fasterxml.jackson.annotation.JsonCreator;
import ru.yandex.webmaster3.core.notification.LanguageEnum;

import java.util.Set;

/**
 * @author avhaliullin
 */
public class ReceiverUserInfo {
    private final long userId;
    private final String login;
    private final String email;
    private final LanguageEnum language;
    private final String fio;
    private final String host;
    private final Set<NotificationChannel> enabledChannels;

    @JsonCreator
    public ReceiverUserInfo(long userId, String login, String email, LanguageEnum language,
                            Set<NotificationChannel> enabledChannels, String fio, String host) {
        this.userId = userId;
        this.login = login;
        this.email = email;
        this.language = language;
        this.enabledChannels = enabledChannels;
        this.fio = fio;
        this.host = host;
    }

    public String getFio() {
        return fio;
    }

    public String getHost() {
        return host;
    }

    public long getUserId() {
        return userId;
    }

    public String getLogin() {
        return login;
    }

    public String getEmail() {
        return email;
    }

    public Set<NotificationChannel> getEnabledChannels() {
        return enabledChannels;
    }

    public LanguageEnum getLanguage() {
        return language;
    }
}
