package ru.yandex.webmaster3.storage.notifications;

import org.joda.time.DateTime;

import java.util.UUID;

/**
 * @author avhaliullin
 */
public class SearchBaseNotificationInfo {
    private final UUID notificationId;
    private final UUID recListId;
    private final DateTime notificationDate;
    private final boolean sendBaseUpdate;
    private final boolean sendImportantUrls;
    private final boolean sending;

    public SearchBaseNotificationInfo(UUID notificationId, UUID recListId, DateTime notificationDate, boolean sendBaseUpdate, boolean sendImportantUrls, boolean sending) {
        this.notificationId = notificationId;
        this.recListId = recListId;
        this.notificationDate = notificationDate;
        this.sendBaseUpdate = sendBaseUpdate;
        this.sendImportantUrls = sendImportantUrls;
        this.sending = sending;
    }

    public UUID getNotificationId() {
        return notificationId;
    }

    public UUID getRecListId() {
        return recListId;
    }

    public DateTime getNotificationDate() {
        return notificationDate;
    }

    public boolean isSendBaseUpdate() {
        return sendBaseUpdate;
    }

    public boolean isSendImportantUrls() {
        return sendImportantUrls;
    }

    public boolean isSending() {
        return sending;
    }

    public SearchBaseNotificationInfo withSending(boolean sending) {
        return new SearchBaseNotificationInfo(notificationId, recListId, notificationDate, sendBaseUpdate, sendImportantUrls, sending);
    }

    public SearchBaseNotificationInfo withRecListId(UUID recListId) {
        return new SearchBaseNotificationInfo(notificationId, recListId, notificationDate, sendBaseUpdate, sendImportantUrls, sending);
    }
}
