package ru.yandex.webmaster3.storage.notifications;

import ru.yandex.webmaster3.storage.user.notification.HostNotificationMode;
import ru.yandex.webmaster3.storage.user.notification.NotificationType;

/**
 * Created by ifilippov5 on 28.08.18.
 */
public class SubscriptionFromEmailInfo {
    private final String token;
    private final Long userId;
    private final String email;
    private final String login;
    private final NotificationType type;
    private final NotificationChannel channel;
    private final HostNotificationMode mode;

    public SubscriptionFromEmailInfo(String token, long userId, String email, String login,
                            NotificationType type, NotificationChannel channel, HostNotificationMode mode) {
        this.token = token;
        this.userId = userId;
        this.email = email;
        this.login = login;
        this.type = type;
        this.channel = channel;
        this.mode = mode;
    }

    public String getToken() {
        return token;
    }

    public Long getUserId() {
        return userId;
    }

    public String getEmail() {
        return email;
    }

    public String getLogin() {
        return login;
    }

    public NotificationType getType() {
        return type;
    }

    public NotificationChannel getChannel() {
        return channel;
    }

    public HostNotificationMode getMode() {
        return mode;
    }
}
