package ru.yandex.webmaster3.storage.notifications.dao;

import ru.yandex.webmaster3.storage.notifications.NotificationChannel;
import ru.yandex.webmaster3.storage.util.clickhouse2.AbstractClickhouseDao;
import ru.yandex.webmaster3.storage.util.clickhouse2.ClickhouseException;

import java.util.Collection;
import java.util.EnumSet;
import java.util.Set;
import java.util.UUID;

/**
 * @author avhaliullin
 */
public abstract class AbstractNotificationDao extends AbstractClickhouseDao {
    protected static final String DB_NAME = "webmaster3_notifications";

    protected static String inTableName(UUID uuid) {
        return uuid.toString().replace("-", "");
    }

    protected void createTable(String createSt) throws ClickhouseException {
        executeOnAllHosts(createSt);
    }

    protected static int encodeChannels(Collection<NotificationChannel> channels) {
        int result = 0;
        for (NotificationChannel channel : channels) {
            result |= 1 << channel.value();
        }
        return result;
    }

    protected static Set<NotificationChannel> decodeChannels(int channels) {
        Set<NotificationChannel> result = EnumSet.noneOf(NotificationChannel.class);
        for (NotificationChannel channel : NotificationChannel.values()) {
            if ((channels & (1 << channel.value())) > 0) {
                result.add(channel);
            }
        }
        return result;
    }
}
