package ru.yandex.webmaster3.storage.notifications.dao;

import java.time.Duration;

import org.joda.time.DateTime;
import org.joda.time.LocalDate;
import org.joda.time.LocalTime;
import org.springframework.stereotype.Repository;

import ru.yandex.webmaster3.storage.util.ydb.AbstractYDao;
import ru.yandex.webmaster3.storage.util.ydb.querybuilder.typesafe.Field;
import ru.yandex.webmaster3.storage.util.ydb.querybuilder.typesafe.Fields;


/**
 * @author kravchenko99 2021
 */
@Repository
public class EuEmailYDao extends AbstractYDao {

    private static final Duration TIMEOUT = Duration.ofSeconds(120);
    public EuEmailYDao() {
        super(PREFIX_NOTIFICATION, "eu_email");
    }

    public boolean contains(String address, LocalDate importedDate) {
        return select(F.EMAIL_ADDRESS)
                .where(F.EMAIL_ADDRESS.eq(address))
                .and(F.IMPORTED_DATE.gte(dateToDateTime(importedDate)))
                .limit(1)
                .queryOne() != null;
    }

    private DateTime dateToDateTime(LocalDate date) {
        return date.toDateTime(LocalTime.MIDNIGHT);
    }

    private static class F {
        static final Field<String> EMAIL_ADDRESS = Fields.stringField("email_address");
        static final Field<DateTime> IMPORTED_DATE = Fields.jodaDateTimeField("imported_date");
    }
}
