package ru.yandex.webmaster3.storage.notifications.dao;

import org.jetbrains.annotations.NotNull;
import ru.yandex.webmaster3.core.data.WebmasterHostId;
import ru.yandex.webmaster3.core.notification.LanguageEnum;
import ru.yandex.webmaster3.storage.notifications.NotificationChannel;
import ru.yandex.webmaster3.storage.user.message.content.MessageContent;

import java.util.Set;

/**
 * @author avhaliullin
 */
public class PreparedGlobalMessageInfo {
    private final long userId;
    private final String email;
    private final String path;
    private final MessageContent message;
    private final Set<NotificationChannel> channels;
    private final LanguageEnum lang;
    private final String login;
    private final String fio;

    public PreparedGlobalMessageInfo(long userId, String email, String path, MessageContent message,
                                     Set<NotificationChannel> channels, LanguageEnum lang, String login, String fio) {
        this.userId = userId;
        this.email = email;
        this.path = path;
        this.message = message;
        this.channels = channels;
        this.lang = lang;
        this.login = login;
        this.fio = fio;
    }

    public long getUserId() {
        return userId;
    }

    public MessageContent getMessage() {
        return message;
    }

    public String getPath() {
        return path;
    }

    public Set<NotificationChannel> getChannels() {
        return channels;
    }

    public String getEmail() {
        return email;
    }

    public LanguageEnum getLang() {
        return lang;
    }

    public String getLogin() {
        return login;
    }

    public String getFio() {
        return fio;
    }

    @NotNull
    public String getHostIdStr() {
        return getHostId() == null ? "" : getHostId().toString();
    }

    public WebmasterHostId getHostId() {
        return message instanceof MessageContent.HostMessageContent ?
                ((MessageContent.HostMessageContent) message).getHostId() : null;
    }
}
