package ru.yandex.webmaster3.storage.notifications.dao;

import java.util.List;

import org.apache.commons.lang3.tuple.Pair;
import org.springframework.stereotype.Repository;

import ru.yandex.webmaster3.storage.util.ydb.AbstractYDao;
import ru.yandex.webmaster3.storage.util.ydb.querybuilder.typesafe.Field;
import ru.yandex.webmaster3.storage.util.ydb.querybuilder.typesafe.Fields;
import ru.yandex.webmaster3.storage.util.ydb.querybuilder.typesafe.ValueDataMapper;

/**
 * WMC-7004
 * @author akhazhoyan 02/2019
 */
@Repository
public class ReceivedServiceSubscriptionNotificationYDao extends AbstractYDao {

    public ReceivedServiceSubscriptionNotificationYDao() {
        super(PREFIX_NOTIFICATION, "received_service_subscription_notification");
    }

    public void insert(long userId) {
        upsert(F.USER_ID.value(userId))
                .execute();
    }
    public void insert(List<Long> lst) {
        batchInsert(V_MAPPER, lst)
                .execute();
    }

    public boolean contains(long userId) {
        return select(F.USER_ID)
                .where(F.USER_ID.eq(userId))
                .limit(1)
                .queryForList()
                .size() > 0;
    }

    ValueDataMapper<Long> V_MAPPER = ValueDataMapper.create2(Pair.of(F.USER_ID, x -> x));


    private static class F {
        static final Field<Long> USER_ID = Fields.longField("user_id");
    }
}
