package ru.yandex.webmaster3.storage.notifications.service;

import lombok.RequiredArgsConstructor;
import org.jetbrains.annotations.NotNull;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import ru.yandex.webmaster3.core.data.WebmasterUser;
import ru.yandex.webmaster3.storage.notifications.dao.HostRemovalNotificationsYDao;
import ru.yandex.webmaster3.storage.notifications.dao.NotMainMirrorNotificationsYDao;
import ru.yandex.webmaster3.storage.notifications.dao.TokensForUnsubscribeYDao;
import ru.yandex.webmaster3.storage.user.UserTakeoutDataProvider;

import java.util.List;

/**
 * @author leonidrom
 */
@Service
@RequiredArgsConstructor(onConstructor_ = @Autowired)
public class UserTakeoutDataProviderService implements UserTakeoutDataProvider {
    private final TokensForUnsubscribeYDao tokensForUnsubscribeYDao;
    private final NotMainMirrorNotificationsYDao notMainMirrorNotificationsYDao;
    private final HostRemovalNotificationsYDao hostRemovalNotificationsYDao;

    @Override
    public void deleteUserData(WebmasterUser user) {
        long userId = user.getUserId();
        tokensForUnsubscribeYDao.deleteForUser(userId);
        notMainMirrorNotificationsYDao.deleteForUser(userId);
        hostRemovalNotificationsYDao.deleteForUser(userId);
    }

    @Override
    public @NotNull List<String> getTakeoutTables() {
        return List.of(
                tokensForUnsubscribeYDao.getTablePath(),
                notMainMirrorNotificationsYDao.getTablePath(),
                hostRemovalNotificationsYDao.getTablePath()
        );
    }
}
