package ru.yandex.webmaster3.storage.oldwmc;

import org.jetbrains.annotations.Nullable;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;
import ru.yandex.webmaster3.core.data.WebmasterHostId;
import ru.yandex.webmaster3.storage.util.ydb.AbstractYDao;
import ru.yandex.webmaster3.storage.util.ydb.querybuilder.typesafe.Field;
import ru.yandex.webmaster3.storage.util.ydb.querybuilder.typesafe.Fields;

/**
 * @author leonidrom
 */

@Repository
public class OldWmcHostIdsYDao extends AbstractYDao  {
    private static final String TABLE_NAME = "host_ids";

    @Autowired
    public OldWmcHostIdsYDao() {
        super("/webmaster3/oldwmc", TABLE_NAME);
    }

    public void add(long oldHostId, WebmasterHostId hostId) {
        upsert(F.OLD_HOST_ID.value(oldHostId), F.HOST_ID.value(hostId)).execute();
    }

    @Nullable
    public WebmasterHostId get(long oldHostId) {
        return select(F.HOST_ID).where(F.OLD_HOST_ID.eq(oldHostId)).queryOne();
    }

    private static final class F {
        public static final Field<Long> OLD_HOST_ID = Fields.longField("old_host_id");
        public static final Field<WebmasterHostId> HOST_ID = Fields.hostIdField("host_id");
    }
}
