package ru.yandex.webmaster3.storage.originaltext;

import com.fasterxml.jackson.annotation.JsonCreator;

/**
 * @author aherman
 */
public class OriginalTextLimits {
    private final int minTextLength;
    private final int maxTextLength;

    private final int textQuotaUsed;
    private final int textQuota;

    @JsonCreator
    public OriginalTextLimits(int minTextLength, int maxTextLength, int textQuotaUsed, int textQuota) {
        this.minTextLength = minTextLength;
        this.maxTextLength = maxTextLength;
        this.textQuota = textQuota;
        this.textQuotaUsed = textQuotaUsed;
    }

    public int getMinTextLength() {
        return minTextLength;
    }

    public int getMaxTextLength() {
        return maxTextLength;
    }

    public int getTextQuotaUsed() {
        return textQuotaUsed;
    }

    public int getTextQuota() {
        return textQuota;
    }
}
