package ru.yandex.webmaster3.storage.originaltext;

import ru.yandex.webmaster3.core.data.WebmasterHostId;
import ru.yandex.webmaster3.core.util.PageUtils;

/**
 * @author avhaliullin
 */
public interface OriginalTextService {
    default OriginalsResponse listTexts(WebmasterHostId hostId, PageUtils.Pager pager) {
        return listTexts(hostId, pager.toRangeStart(), pager.getPageSize());
    }

    OriginalsResponse listTexts(WebmasterHostId hostId, int offset, int limit);

    OriginalsResponse addText(WebmasterHostId hostId, String text);

    OriginalTextLimits getLimits(WebmasterHostId hostId);

    void deleteText(WebmasterHostId hostId, String textId);
}
