package ru.yandex.webmaster3.storage.originaltext;

import com.fasterxml.jackson.annotation.JsonCreator;

import java.util.List;
import java.util.Optional;

/**
 * @author aherman
 */
public class OriginalsResponse {
    private final int totalTexts;
    private final Optional<Boolean> canAdd;
    private final OriginalsError error;

    private final List<OriginalText> texts;

    @JsonCreator
    public OriginalsResponse(int totalTexts, Optional<Boolean> canAdd, List<OriginalText> texts, OriginalsError error) {
        this.totalTexts = totalTexts;
        this.canAdd = canAdd;
        this.texts = texts;
        this.error = error;
    }

    public int getTotalTexts() {
        return totalTexts;
    }

    public Optional<Boolean> isCanAdd() {
        return canAdd;
    }

    public List<OriginalText> getTexts() {
        return texts;
    }

    public OriginalsError getError() {
        return error;
    }

    public boolean isErrorState() {
        return error != OriginalsError.NO_ERROR;
    }

    public static enum OriginalsError {
        NO_ERROR,

        TEXT_ALREADY_ADDED,
        UNKNOWN_ERROR
    }
}
