package ru.yandex.webmaster3.storage.payments;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.AllArgsConstructor;
import lombok.Value;
import org.joda.time.DateTime;

import ru.yandex.webmaster3.core.payments.ServiceMerchantInfo;
import ru.yandex.webmaster3.core.payments.ServiceMerchantOrganization;

/**
 * Created by Oleg Bazdyrev on 2019-05-28.
 */
@Value
@AllArgsConstructor(onConstructor_ = @JsonCreator)
@JsonIgnoreProperties(ignoreUnknown = true)
public class ServiceMerchantData {

    @JsonProperty("trustworthy")
    boolean trustworthy;
    @JsonProperty("revision")
    int revision;
    @JsonProperty("uid")
    long uid;
    @JsonProperty("updated")
    DateTime updated;
    @JsonProperty("entity_id")
    String entityId;
    @JsonProperty("deleted")
    boolean deleted;
    @JsonProperty("enabled")
    boolean enabled;
    @JsonProperty("service_merchant_id")
    long serviceMerchantId;
    @JsonProperty("service_id")
    long serviceId;
    @JsonProperty("created")
    DateTime created;
    @JsonProperty("description")
    String description;
    @JsonProperty("organization")
    ServiceMerchantOrganization organization;
    @JsonProperty("moderation")
    ModerationInfo moderation;

    public ServiceMerchantInfo toServiceMerchantInfo() {
        boolean enabled = this.enabled;
        // WMC-10602
        if (enabled && moderation != null && !moderation.approved && !trustworthy) {
            enabled = false;
        }
        return new ServiceMerchantInfo(serviceMerchantId, serviceId, enabled, entityId, description, created,
                updated, DateTime.now(), organization);
    }

    @Value
    @AllArgsConstructor(onConstructor_ = @JsonCreator)
    @JsonIgnoreProperties(ignoreUnknown = true)
    public static final class ModerationInfo {
        @JsonProperty("hasModeration")
        boolean hasModeration;
        @JsonProperty("hasOngoing")
        boolean hasOngoing;
        @JsonProperty("approved")
        boolean approved;
    }
}
