package ru.yandex.webmaster3.storage.payments;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;

/**
 * Created by Oleg Bazdyrev on 2019-05-30.
 */
public class ServiceMerchantResponse {

    private final int code;
    private final String status;
    private final ServiceMerchantData data;

    @JsonCreator
    public ServiceMerchantResponse(
            @JsonProperty("code") int code,
            @JsonProperty("status") String status,
            @JsonProperty("data") ServiceMerchantData data) {
        this.code = code;
        this.status = status;
        this.data = data;
    }

    public int getCode() {
        return code;
    }

    public String getStatus() {
        return status;
    }

    public ServiceMerchantData getData() {
        return data;
    }
}
