package ru.yandex.webmaster3.storage.postpone;

import java.util.function.Consumer;

import com.datastax.driver.core.utils.UUIDs;
import org.joda.time.DateTime;
import org.joda.time.Duration;
import org.springframework.stereotype.Repository;

import ru.yandex.webmaster3.storage.util.ydb.AbstractYDao;
import ru.yandex.webmaster3.storage.util.ydb.querybuilder.typesafe.DataMapper;
import ru.yandex.webmaster3.storage.util.ydb.querybuilder.typesafe.Field;
import ru.yandex.webmaster3.storage.util.ydb.querybuilder.typesafe.Fields;


/**
 * ishalaru
 * 11.03.2020
 * Таблица с ttl в 7 дней
 **/
@Repository
public class PostponeActionYDao extends AbstractYDao {
    private static final Duration TTL = Duration.standardDays(7);
    public static final String TABLE_NAME = "postpone_action";

    public PostponeActionYDao() {
        super(PREFIX_WEBMASTER3, TABLE_NAME);
    }

    public void loadPostponedData(Consumer<PostponeData> consumer) {
        streamReader(MAPPER, consumer);
    }

    public boolean check(DateTime date, PostponeOperationType postponeOperationType) {
        return queryOne(select(F.DATE)
                .where(F.DATE.eq(date)).and(F.TYPE.eq(postponeOperationType))
                .limit(1), DATE_MAPPER) != null;

    }

    public void insert(DateTime date, PostponeOperationType postponeOperationType, String data) {
        execute(insert(F.DATE.value(date),
                F.TYPE.value(postponeOperationType),
                F.UUID.value(UUIDs.timeBased().toString()),
                F.JSON_DATA.value(data)));
    }

    public void delete(PostponeData data) {
        delete().where(F.DATE.eq(data.getDate())).and(F.TYPE.eq(data.getType())).and(F.UUID.eq(data.getUid())).execute();
    }

    private static final DataMapper<PostponeData> MAPPER = DataMapper.create(
            F.DATE, F.TYPE, F.JSON_DATA, F.UUID, PostponeData::new
    );
    public static final DataMapper<DateTime> DATE_MAPPER = DataMapper.create(F.DATE, e -> e);


    interface F {
        Field<DateTime> DATE = Fields.jodaDateTimeField("date");
        Field<PostponeOperationType> TYPE = Fields.intEnumField("type", PostponeOperationType.R);
        Field<String> UUID = Fields.stringField("uuid");
        Field<String> JSON_DATA = Fields.stringField("data");
    }

}
