package ru.yandex.webmaster3.storage.radar;

import java.util.List;

import org.apache.commons.lang3.tuple.Pair;
import org.springframework.stereotype.Repository;

import ru.yandex.webmaster3.core.metrika.radar.HostAllowedMetrica;
import ru.yandex.webmaster3.storage.util.ydb.AbstractYDao;
import ru.yandex.webmaster3.storage.util.ydb.querybuilder.typesafe.DataMapper;
import ru.yandex.webmaster3.storage.util.ydb.querybuilder.typesafe.Field;
import ru.yandex.webmaster3.storage.util.ydb.querybuilder.typesafe.Fields;

@Repository
public class RadarHostsAllowedMetrikaYDao extends AbstractYDao {
    private static final String TABLE_NAME = "radar_hosts_allowed_metrika";

    protected RadarHostsAllowedMetrikaYDao() {
        super(PREFIX_METRIKA, TABLE_NAME);
    }

    public void add(HostAllowedMetrica allowedMetrica) {
        upsert(
                F.HOST_URL.value(allowedMetrica.getHostUrl()),
                F.ALLOWED_METRIKA.value(allowedMetrica.isAllowedMetrica()),
                F.ALLOWED_APP_METRIKA.value(allowedMetrica.isAllowedAppMetrica())
        )
                .execute();
    }

    public HostAllowedMetrica get(String hostUrl) {
        return select(MAPPER)
                .where(F.HOST_URL.eq(hostUrl))
                .queryOne();
    }

    public List<HostAllowedMetrica> getAllFlags() {
        return select(MAPPER)
                .queryForList(Pair.of(F.HOST_URL, HostAllowedMetrica::getHostUrl));
    }

    private static final DataMapper<HostAllowedMetrica> MAPPER = DataMapper.create(
            F.HOST_URL, F.ALLOWED_METRIKA,
            F.ALLOWED_APP_METRIKA,
            HostAllowedMetrica::new
    );

    private static class F {
        static final Field<String> HOST_URL = Fields.stringField("host_url");
        static final Field<Boolean> ALLOWED_METRIKA = Fields.boolField("allowed_metrika");
        static final Field<Boolean> ALLOWED_APP_METRIKA = Fields.boolField("allowed_app_metrika");
    }
}
