package ru.yandex.webmaster3.storage.radar;

import com.fasterxml.jackson.annotation.JsonIgnore;
import ru.yandex.webmaster3.core.notification.LanguageEnum;

import java.util.EnumMap;
import java.util.Map;
import java.util.Objects;

/**
 * Created by Oleg Bazdyrev on 29/11/2018.
 */
public class RadarThematics {

    public static final String ROOT_ID = "_root_";

    private final String parentId;
    private final String id;
    private final Map<LanguageEnum, String> names;
    private final boolean visible;

    public RadarThematics(String parentId, String id, Map<LanguageEnum, String> names, boolean visible) {
        this.parentId = parentId;
        this.id = id;
        this.names = names;
        this.visible = visible;
    }

    public String getParentId() {
        return parentId;
    }

    public String getId() {
        return id;
    }

    @JsonIgnore
    public String getFullId() {
        if (ROOT_ID.equals(parentId)) {
            return id;
        }
        return parentId + "/" + id;
    }

    public Map<LanguageEnum, String> getNames() {
        return names;
    }

    public boolean isVisible() {
        return visible;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        RadarThematics that = (RadarThematics) o;
        return Objects.equals(parentId, that.parentId) &&
                Objects.equals(id, that.id);
    }

    @Override
    public int hashCode() {
        return Objects.hash(parentId, id);
    }
}
