package ru.yandex.webmaster3.storage.recommendedquery.dao;

import org.joda.time.DateTime;
import org.springframework.stereotype.Repository;

import ru.yandex.webmaster3.storage.util.ydb.AbstractYDao;
import ru.yandex.webmaster3.storage.util.ydb.querybuilder.typesafe.Field;
import ru.yandex.webmaster3.storage.util.ydb.querybuilder.typesafe.Fields;

/**
 * @author avhaliullin
 */
@Repository
public class DomainsWithDirectDynamicAdsYDao extends AbstractYDao {

    public DomainsWithDirectDynamicAdsYDao() {
        super(PREFIX_QUERIES, "domains_with_direct_dynamic_ads");
    }

    public boolean containsDomain(String domain) {
        return countAll().where(F.DOMAIN.eq(domain)).queryOne() > 0;
    }

    public void clearOldRecords(DateTime ts) {
        delete().where(F.LAST_UPDATE.lt(ts)).execute();
    }

    private interface F {
        Field<String> DOMAIN = Fields.stringField("domain");
        Field<DateTime> LAST_UPDATE = Fields.jodaDateTimeField("last_update");
    }
}
