package ru.yandex.webmaster3.storage.recommendedquery.dao;

import org.joda.time.Instant;

/**
 * Created by ifilippov5 on 15.03.17.
 */
public class RecommededQueriesTablesUtil {
    public static final String DATABASE_NAME = "webmaster3_queries";

    private static String replicationNodeSuffix(Instant dataUpdateTime) {
        return "upd" + dataUpdateTime.getMillis();
    }

    private static final String RECOMMENDED_QUERIES_CREATE_SPEC_TEMPLATE = "( " +
            "   date Date,  " +
            "   host_id String,  " +
            "   query String,  " +
            "   region_id Int64,  " +
            "   forecasted_bid Float64,   " +
            "   forecasted_budget Float64,  " +
            "   forecasted_clicks Float64,  " +
            "   forecasted_shows Float64,   " +
            "   url String,   " +
            "   position Int8,  " +
            "   weight Float64" +
            ") ENGINE = ReplicatedMergeTree(" +
            "   '/webmaster3/clickhouse/tables/{shard}/webmaster3_queries/" + getTableName() + "_" + "%s', " +
            "   '{replica}', " +
            "   date, " +
            "   (host_id, region_id, forecasted_clicks), " +
            "   8192" +
            ")";

    public static final String RECOMMENDED_QUERIES_INSERT_SPEC = "(" +
            "   date,  " +
            "   host_id,  " +
            "   query,  " +
            "   region_id,  " +
            "   forecasted_bid,  " +
            "   forecasted_budget,   " +
            "   forecasted_clicks,   " +
            "   forecasted_shows,   " +
            "   url,   " +
            "   position,   " +
            "   weight" +
            ") FORMAT TabSeparated";

    public static String getRecommendedQueriesTableCreateSpec(Instant dataUpdateTime) {
        return String.format(RECOMMENDED_QUERIES_CREATE_SPEC_TEMPLATE, replicationNodeSuffix(dataUpdateTime));
    }

    public static String getTableName() {
        return "recommended_queries";
    }
}