package ru.yandex.webmaster3.storage.recommendedquery.data;

import org.joda.time.Instant;
import org.joda.time.LocalDate;
import ru.yandex.webmaster3.storage.util.yt.YtPath;

import java.util.List;
import java.util.UUID;

/**
 * Created by ifilippov5 on 14.03.17.
 */
public class RecommendedQueriesTableImport {
    private final RecommendedQueriesImportType importType;
    private final Instant dataUpdateTime;
    private final RecommendedQueriesTableImportState state;
    private final List<YtPath> ytPreparedTables;
    private final UUID importManagerTaskId;
    private final String tmpTableName;
    private final UUID replicationManagerTaskId;
    private final String replacedTableNewName;

    public RecommendedQueriesTableImport(RecommendedQueriesImportType importType, Instant dataUpdateTime,
                                         RecommendedQueriesTableImportState state, List<YtPath> ytPreparedTables,
                                      UUID importManagerTaskId, String tmpTableName, UUID replicationManagerTaskId,
                                      String replacedTableNewName) {
        this.importType = importType;
        this.dataUpdateTime = dataUpdateTime;
        this.state = state;
        this.ytPreparedTables = ytPreparedTables;
        this.importManagerTaskId = importManagerTaskId;
        this.tmpTableName = tmpTableName;
        this.replicationManagerTaskId = replicationManagerTaskId;
        this.replacedTableNewName = replacedTableNewName;
    }

    @Override
    public String toString() {
        return "{" +
                "importType=" + importType +
                ", dataUpdateTime=" + dataUpdateTime +
                ", state=" + state +
                '}';
    }

    public String getTmpTableName() {
        return tmpTableName;
    }

    public RecommendedQueriesTableImportState getState() {
        return state;
    }

    public RecommendedQueriesTableImport restarted() {
        return create(importType, dataUpdateTime);
    }

    public List<YtPath> getYtPreparedTables() {
        return ytPreparedTables;
    }

    public UUID getImportManagerTaskId() {
        return importManagerTaskId;
    }

    public UUID getReplicationManagerTaskId() {
        return replicationManagerTaskId;
    }

    public String getReplacedTableNewName() {
        return replacedTableNewName;
    }

    public RecommendedQueriesImportType getImportType() {
        return importType;
    }

    public Instant getDataUpdateTime() {
        return dataUpdateTime;
    }

    // update data

    public RecommendedQueriesTableImport withPreparedTables(List<YtPath> ytPreparedTables) {
        return new RecommendedQueriesTableImport(importType, dataUpdateTime, state, ytPreparedTables, importManagerTaskId, tmpTableName, replicationManagerTaskId, replacedTableNewName);
    }

    public RecommendedQueriesTableImport withState(RecommendedQueriesTableImportState state) {
        return new RecommendedQueriesTableImport(importType, dataUpdateTime, state, ytPreparedTables, importManagerTaskId, tmpTableName, replicationManagerTaskId, replacedTableNewName);
    }

    public RecommendedQueriesTableImport failed() {
        return new RecommendedQueriesTableImport(importType, dataUpdateTime, RecommendedQueriesTableImportState.FAILED, ytPreparedTables, importManagerTaskId, tmpTableName, replicationManagerTaskId, replacedTableNewName);
    }

    public RecommendedQueriesTableImport withImportManagerTaskId(UUID importManagerTaskId) {
        return new RecommendedQueriesTableImport(importType, dataUpdateTime, state, ytPreparedTables, importManagerTaskId, tmpTableName, replicationManagerTaskId, replacedTableNewName);
    }

    public RecommendedQueriesTableImport withTmpTable(String tmpTableName) {
        return new RecommendedQueriesTableImport(importType, dataUpdateTime, state, ytPreparedTables, importManagerTaskId, tmpTableName, replicationManagerTaskId, replacedTableNewName);
    }

    public RecommendedQueriesTableImport withReplicationManagerTaskId(UUID replicationManagerTaskId) {
        return new RecommendedQueriesTableImport(importType, dataUpdateTime, state, ytPreparedTables, importManagerTaskId, tmpTableName, replicationManagerTaskId, replacedTableNewName);
    }

    public RecommendedQueriesTableImport withReplacedTableNewName(String replacedTableNewName) {
        return new RecommendedQueriesTableImport(importType, dataUpdateTime, state, ytPreparedTables, importManagerTaskId, tmpTableName, replicationManagerTaskId, replacedTableNewName);
    }

    // static

    public static RecommendedQueriesTableImport create(RecommendedQueriesImportType importType, Instant updateTimeForCurrentTable) {
        return new RecommendedQueriesTableImport(importType, updateTimeForCurrentTable, RecommendedQueriesTableImportState.INIT, null, null, null, null, null);
    }
}
