package ru.yandex.webmaster3.storage.recommendedquery.data;

import ru.yandex.webmaster3.core.util.enums.EnumResolver;

/**
 * Created by ifilippov5 on 14.03.17.
 */
public enum RecommendedQueriesTableImportState {
    PREPARING(false),
    IMPORTING(false),
    REPLICATING(false),
    RENAMING(false),
    CLEANING(false),
    DONE(true),
    FAILED(true),
    ;

    private final boolean terminal;

    RecommendedQueriesTableImportState(boolean terminal) {
        this.terminal = terminal;
    }

    public boolean isTerminal() {
        return terminal;
    }

    public static RecommendedQueriesTableImportState INIT = PREPARING;

    public static EnumResolver<RecommendedQueriesTableImportState> R = EnumResolver.er(RecommendedQueriesTableImportState.class);
}
