package ru.yandex.webmaster3.storage.recommendedquery.download;

import com.fasterxml.jackson.annotation.JsonProperty;
import ru.yandex.webmaster3.core.data.L10nEnum;
import ru.yandex.webmaster3.core.data.WebmasterHostId;
import ru.yandex.webmaster3.core.download.FileFormat;
import ru.yandex.webmaster3.core.worker.task.WorkerTaskData;
import ru.yandex.webmaster3.core.worker.task.WorkerTaskType;
import ru.yandex.webmaster3.storage.download.DownloadTaskData;
import ru.yandex.webmaster3.storage.recommendedquery.dao.RecommendedQueriesCHDao;
import ru.yandex.webmaster3.storage.recommendedquery.filtres.RecommendedQueryField;
import ru.yandex.webmaster3.storage.util.clickhouse2.condition.Condition;
import ru.yandex.webmaster3.storage.util.clickhouse2.query.OrderBy;

import java.util.UUID;

/**
 * Created by ifilippov5 on 20.03.17.
 */
public class DownloadRecommendedQueriesTaskData extends DownloadTaskData<RecommendedQueryCsvRow> {
    private final Condition filters;
    private final RecommendedQueryField orderBy;
    private final OrderBy.Direction orderDirection;
    private final L10nEnum lang;
    private final RecommendedQueriesCHDao.Include include;

    public DownloadRecommendedQueriesTaskData(
            @JsonProperty("taskId") UUID taskId,
            @JsonProperty("hostId") WebmasterHostId hostId,
            @JsonProperty("filters") Condition filters,
            @JsonProperty("orderBy") RecommendedQueryField orderBy,
            @JsonProperty("orderDirection") OrderBy.Direction orderDirection,
            @JsonProperty("exportFormat") FileFormat exportFormat,
            @JsonProperty("fileName") String fileName,
            @JsonProperty("hash") Long hash,
            @JsonProperty("lang") L10nEnum lang,
            @JsonProperty("include") RecommendedQueriesCHDao.Include include) {
        super(taskId, hostId, null, exportFormat, fileName, hash, RecommendedQueryCsvRow.class);
        this.filters = filters;
        this.orderBy = orderBy;
        this.orderDirection = orderDirection;
        this.lang = lang;
        this.include = include;
    }

    private DownloadRecommendedQueriesTaskData(WebmasterHostId hostId, Condition filters, Long regionId,
                                               RecommendedQueryField orderBy, OrderBy.Direction orderDirection,
                                               FileFormat exportFormat, String fileName, Long hash,
                                               L10nEnum lang, RecommendedQueriesCHDao.Include include) {
        super(hostId, null, exportFormat, fileName, hash, RecommendedQueryCsvRow.class);
        this.filters = filters;
        this.orderBy = orderBy;
        this.orderDirection = orderDirection;
        this.lang = lang;
        this.include = include;
    }

    public static WorkerTaskData createTaskData(WebmasterHostId hostId, Condition filters, Long regionId,
                                                RecommendedQueryField orderBy, OrderBy.Direction orderDirection,
                                                FileFormat exportFormat, String fileName, Long hash, L10nEnum lang,
                                                RecommendedQueriesCHDao.Include include) {
        return new DownloadRecommendedQueriesTaskData(
                hostId, filters, regionId, orderBy, orderDirection, exportFormat, fileName, hash, lang, include
        );
    }

    @Override
    public WorkerTaskType getTaskType() {
        return WorkerTaskType.DOWNLOAD_RECOMMENDED_QUERIES;
    }

    @Override
    public String getShortDescription() {
        return "Download recommended queries";
    }

    public Condition getFilters() {
        return filters;
    }

    public RecommendedQueryField getOrderBy() {
        return orderBy;
    }

    public OrderBy.Direction getOrderDirection() {
        return orderDirection;
    }

    public L10nEnum getLang() {
        return lang;
    }

    public RecommendedQueriesCHDao.Include getInclude() {
        return include;
    }
}
