package ru.yandex.webmaster3.storage.recommendedquery.download;

import ru.yandex.webmaster3.core.xcelite.annotations.Column;
import ru.yandex.webmaster3.core.xcelite.annotations.Row;
import com.opencsv.bean.CsvBindByName;
import ru.yandex.webmaster3.storage.recommendedquery.samples.RecommendedQuery;

import java.util.Optional;
import java.util.function.Function;

/**
 * Created by ifilippov5 on 21.03.17.
 */
@Row(colsOrder = {"query", "regionName", "forecastedBid", "forecastedClicks", "forecastedShows", "url", "position"})
public class RecommendedQueryCsvRow {
    @CsvBindByName
    @Column
    private final String query;

    @CsvBindByName
    @Column
    private final String regionName;

    @CsvBindByName
    @Column
    private final String forecastedBid;

    @CsvBindByName
    @Column
    private final String forecastedClicks;

    @CsvBindByName
    @Column
    private final String forecastedShows;

    @CsvBindByName
    @Column
    private final String url;

    @CsvBindByName
    @Column
    private final int position;

    private RecommendedQueryCsvRow(String query, String regionName, String forecastedBid,
                                    String forecastedClicks, String forecastedShows, String url, int position) {
        this.query = Optional.ofNullable(query).orElse("");
        this.regionName = regionName;
        this.forecastedBid = forecastedBid;
        this.forecastedClicks = forecastedClicks;
        this.forecastedShows = forecastedShows;
        this.url = Optional.ofNullable(url).orElse("");
        this.position = position;
    }

    public RecommendedQueryCsvRow(RecommendedQuery sample, Function<Double, String> doubleFormatter, String region) {
        this(sample.getQuery(),
                region,
                doubleFormatter.apply(sample.getForecastedBid()),
                doubleFormatter.apply(sample.getForecastedClicks()),
                doubleFormatter.apply(sample.getForecastedShows()),
                sample.getUrl(),
                sample.getPosition());
    }

    public String getQuery() {
        return query;
    }

    public String getRegionName() {
        return regionName;
    }

    public String getForecastedBid() {
        return forecastedBid;
    }

    public String getForecastedClicks() {
        return forecastedClicks;
    }

    public String getForecastedShows() {
        return forecastedShows;
    }

    public String getUrl() {
        return url;
    }

    public int getPosition() {
        return position;
    }
}

