package ru.yandex.webmaster3.storage.recommendedquery.samples;

import ru.yandex.webmaster3.core.data.WebmasterHostId;

import java.math.BigDecimal;
import java.math.RoundingMode;

/**
 * Created by ifilippov5 on 10.03.17.
 */
public class RecommendedQuery {
    private WebmasterHostId hostId;
    private final String query;
    private final long regionId;
    private final double forecastedBid;
    private final double forecastedBudget;
    private final double forecastedClicks;
    private final double forecastedShows;
    private final String url;
    private final int position;
    private final boolean isExtended;

    public RecommendedQuery(WebmasterHostId hostId, String query, long regionId, double forecastedBid,
                            double forecastedBudget, double forecastedClicks, double forecastedShows, String url,
                            int position, boolean isExtended) {
        this.hostId = hostId;
        this.query = query;
        this.regionId = regionId;
        this.forecastedBid = forecastedBid;
        this.forecastedBudget = forecastedBudget;
        this.forecastedClicks = forecastedClicks;
        this.forecastedShows = forecastedShows;
        this.url = url;
        this.position = position;
        this.isExtended = isExtended;
    }

    public WebmasterHostId getHostId() {
        return hostId;
    }

    public String getQuery() {
        return query;
    }

    public long getRegionId() {
        return regionId;
    }

    public double getForecastedBid() {
        return forecastedBid;
    }

    public double getForecastedBudget() {
        return forecastedBudget;
    }

    public double getForecastedClicks() {
        return forecastedClicks;
    }

    public double getForecastedShows() {
        return forecastedShows;
    }

    public String getUrl() {
        return url;
    }

    public int getPosition() {
        return position;
    }

    public boolean isExtended() {
        return isExtended;
    }

    public RecommendedQuery toRoundedSample() {
        return new RecommendedQuery(hostId, query, regionId, roundBid(forecastedBid), forecastedBudget,
                                    roundClicks(forecastedClicks), forecastedShows, url, position, isExtended);
    }

    private static double roundBid(double v) {
        return new BigDecimal(v).setScale(1, RoundingMode.HALF_EVEN).doubleValue();
    }

    private static double roundClicks(double v) {
        if (v < 1) {
            return new BigDecimal(v).setScale(1, RoundingMode.HALF_UP).doubleValue();
        }
        return new BigDecimal(v).setScale(0, RoundingMode.HALF_EVEN).doubleValue();
    }
}
