package ru.yandex.webmaster3.storage.review;

import java.util.Collection;
import java.util.List;

import lombok.RequiredArgsConstructor;
import org.jetbrains.annotations.NotNull;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import ru.yandex.webmaster3.core.data.WebmasterHostId;
import ru.yandex.webmaster3.core.data.WebmasterUser;
import ru.yandex.webmaster3.storage.review.dao.ReviewComplaintYDao;
import ru.yandex.webmaster3.storage.user.UserTakeoutDataProvider;

/**
 * @author: ishalaru
 * DATE: 19.07.2019
 */
@Service("complaintService")
@RequiredArgsConstructor(onConstructor_ = @Autowired)
public class ComplaintService implements UserTakeoutDataProvider {

    private final ReviewComplaintYDao reviewComplaintYDao;

    public List<String> check(WebmasterHostId hostId, Collection<String> reviewIds) {
        return reviewComplaintYDao.check(hostId, reviewIds);
    }

    public boolean insert(WebmasterHostId hostId, String reviewId, Long userId) {
        return reviewComplaintYDao.insertIfNotExist(hostId, reviewId, userId);
    }

    public void delete(WebmasterHostId hostId, String reviewId) {
        reviewComplaintYDao.delete(hostId, reviewId);
    }

    @Override
    public void deleteUserData(WebmasterUser user) {
        reviewComplaintYDao.deleteForUser(user.getUserId());
    }

    @Override
    public @NotNull List<String> getTakeoutTables() {
        return List.of(
                reviewComplaintYDao.getTablePath()
        );
    }
}
