package ru.yandex.webmaster3.storage.robotstxt;


import lombok.AllArgsConstructor;
import lombok.Value;
import org.apache.commons.lang3.StringUtils;
import org.joda.time.Instant;

import ru.yandex.webmaster3.core.data.WebmasterHostId;

/**
 * @author kravchenko99
 * @date 4/5/21
 */

@Value
@AllArgsConstructor
public class RobotTxtInfo {
    private static final int CASSANDRA_STRING_FIELD_THRESHOLD = 32_000;

    WebmasterHostId hostId;
    Instant dateAdded;
    String content;

    public RobotTxtInfo(WebmasterHostId hostId, long timestampMillis, String content) {
        this.hostId = hostId;
        this.dateAdded = RobotsTxtService.timestampMillisToInstant(timestampMillis);
        this.content = StringUtils.left(content, CASSANDRA_STRING_FIELD_THRESHOLD);

    }
}
