package ru.yandex.webmaster3.storage.robotstxt.model;

/**
 * @author: ishalaru
 * DATE: 20.05.2019
 * List of error in analyze robotstxt process.
 */
public enum AnalyzeRobotsTxtErrorType {
    ANALYZE_ROBOTSTXT__UNABLE_TO_DOWNLOAD_ROBOTS_TXT("Unable to download robots.txt content"),
    ANALYZE_ROBOTSTXT__ILLEGAL_HTTP_CODE("Illegal http code for robots.txt"),
    ANALYZE_ROBOTSTXT__REDIRECT_NOT_SUPPORTED("Robots.txt must not redirect"),
    ANALYZE_ROBOTSTXT__EMPTY_ROBOTS_TXT("Robots.txt is empty"),
    ANALYZE_ROBOTSTXT__TOO_MANY_URLS("Too many urls to check");

    private String errorDescription;

    AnalyzeRobotsTxtErrorType(String errorDescription) {
        this.errorDescription = errorDescription;
    }

    public String getErrorDescription() {
        return errorDescription;
    }
}
