package ru.yandex.webmaster3.storage.robotstxt.model;

import org.apache.commons.lang3.StringUtils;
import ru.yandex.autodoc.common.doc.annotation.Description;
import ru.yandex.webmaster3.core.http.RequestQueryProperty;
import ru.yandex.webmaster3.storage.async.model.IRequestData;

/**
 * @author: ishalaru
 * DATE: 20.05.2019
 * Pojo class for save data in storage
 */
public class AnalyzeRobotsTxtInputData implements IRequestData {
    private String robotsTxtContent;
    private String hostName;
    private boolean loadOnly = false;
    private String urls;

    public AnalyzeRobotsTxtInputData(String robotsTxtContent, String hostName, boolean loadOnly, String urls) {
        this.robotsTxtContent = robotsTxtContent;
        this.hostName = hostName;
        this.loadOnly = loadOnly;
        this.urls = urls;
    }

    public String getRobotsTxtContent() {
        return robotsTxtContent;
    }

    @Description(value = "Содержимое файла robotsTxt")
    @RequestQueryProperty
    public void setRobotsTxtContent(String robotsTxtContent) {
        this.robotsTxtContent = robotsTxtContent;
    }

    public String getHostName() {
        return hostName;
    }

    @Description(value = "Имя хоста")
    @RequestQueryProperty
    public void setHostName(String hostName) {
        this.hostName = hostName;
    }

    public boolean isLoadOnly() {
        return loadOnly;
    }

    @Description(value = "Только загрузить содержимое файла или загрузить и анализировать")
    @RequestQueryProperty
    public void setLoadOnly(boolean loadOnly) {
        this.loadOnly = loadOnly;
    }

    @Description(value = "space-, tab- or newline-separated list of urls")
    @RequestQueryProperty
    public void setUrls(String urls) {
        this.urls = urls;
    }

    public String[] getUrlsAsArray() {
        if (StringUtils.isEmpty(urls)) {
            return new String[0];
        }
        return urls.split("[ \\t\\n\\f\\r]+");
    }
}
