package ru.yandex.webmaster3.storage.robotstxt.model;

import java.util.ArrayList;
import java.util.List;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.AllArgsConstructor;
import lombok.Value;

import ru.yandex.webmaster3.core.robotstxt.FormatErrorType;
import ru.yandex.webmaster3.storage.async.model.IResponseData;

/**
 * @author: ishalaru
 * DATE: 20.05.2019
 */
@Value
@AllArgsConstructor(onConstructor_ = @JsonCreator)
public class AnalyzeRobotsTxtResult implements IResponseData {
    @JsonProperty("robotsTxtContent") String robotsTxtContent;
    @JsonProperty("parseErrors") List<RobotsTxtErrorInfo> parseErrors;
    @JsonProperty("acceptedLines") List<RobotsTxtSection> acceptedLines;
    @JsonProperty("allowInfos") List<RobotsTxtUrlAllowInfo> allowInfos;

    public AnalyzeRobotsTxtResult(final String robotsTxtContent) {
        this(robotsTxtContent, null, null, null);
    }

    @Value
    @AllArgsConstructor(onConstructor_ = @JsonCreator)
    public static class RobotsTxtErrorInfo {
        @JsonProperty("type") FormatErrorType type;
        @JsonProperty("line") long line;
        @JsonProperty("rule") String rule;

        public SeverityEnum getSeverity() {
            switch (type) {
                case ERR_ASTERISK_MULTI:
                case ERR_CRAWL_DELAY_FORMAT:
                case ERR_CRAWL_DELAY_MULTI:
                case ERR_CLEAN_PARAM_FORMAT:
                case ERR_HOST_FORMAT:
                case ERR_HOST_MULTI:
                case ERR_ROBOTS_HUGE:
                case ERR_RULE_BEFORE_USER_AGENT:
                case ERR_RULE_HUGE:
                case ERR_RULE_NOT_SLASH:
                case ERR_SITEMAP_FORMAT:
                    return SeverityEnum.ERROR;

                case WARN_SUSPECT_SYMBOL:
                case WARN_TRASH:
                case WARN_UNKNOWN_FIELD:
                    return SeverityEnum.WARNING;
            }

            return SeverityEnum.WARNING;
        }
    }

    @Value
    @AllArgsConstructor(onConstructor_ = @JsonCreator)
    public static class RobotsTxtSection {
        @JsonProperty("lines") List<RobotsTxtLine> lines;

        public RobotsTxtSection() {
            this(new ArrayList<>());
        }

        public void addLine(RobotsTxtLine line) {
            lines.add(line);
        }
    }

    @Value
    @AllArgsConstructor(onConstructor_ = @JsonCreator)
    public static class RobotsTxtLine {
        @JsonProperty("line") int line;
        @JsonProperty("rule")  String rule;
    }
}
